 ; Ŀ
 ;   Kibl - kill blocks by name or object selection.                       
 ;   Copyright 1995, 2009 by Rocket Software Ltd.                          
 ;   Not a word which conjures up images of heroic deeds.                  
 ; 

 ; Ŀ
 ;   Bget - get a string by keyboard entry or entity selection at the      
 ;   same prompt.                                                          
 ;   Arguments: Proma, a prompt string.                                    
 ;              Vala, association number of the value to return.           
 ;   Returns a string (or possibly another value) or nil.                  
 ;   Calls nothing.                                                        
 ; 
 (DEFUN BGET (proma vala / goon ppstr aa pa pstr)
  (if (and proma (/= proma ""))
      (prompt proma)
      (prompt "\nEnter a Value or Select an Example: "))
 ; Ŀ
 ;   Use grread to get points so can also accept keyboard input.           
 ; 
  (setq ppstr "")
  (setq goon t)
  (while (and goon (setq aa (grread () 4 2)))
         (cond ((= (car aa) 3)                             ; a point
                (setq goon ())                             ; leave loop
                (setq pa (cadr aa)))                       ; save point
               ((equal aa (list 2 13))                     ; Keyboard <Return>
                (setq goon ()))                            ; leave looop
               ((equal (car aa) 25)                        ; Mouse <Return>
                (setq goon ()))                            ; leave looop
               ((equal aa (list 6 0))                      ; Digitizer <Return>
                (setq goon ()))                            ; leave looop
               ((equal aa (list 2 2))                      ; F9
                (setvar "snapmode" (abs (1- (getvar "snapmode")))))
               ((equal aa (list 2 15))                     ; F8
                (setvar "orthomode" (abs (1- (getvar "orthomode")))))
               ((equal (car aa) 2)                         ; a keypress
                (setq ppstr (strcat ppstr (setq aa (chr (cadr aa)))))
                (princ aa))))
  (if pa
      (progn
           (if (/= ppstr "") (prompt "\nPoint override."))
           (if (setq ppstr (ssname (ssget pa) 0))
               (if (= (type ppstr) 'ENAME)
                   (setq pstr (cdr (assoc vala (entget ppstr)))))
              (setq pstr ())))
      (if (/= ppstr "") (setq pstr ppstr)))
 pstr)
 ; Ŀ
 ;   Bget end.                                                             
 ; 

 ; Ŀ
 ;   Kibl.                                                                 
 ; 
 (DEFUN C:KIBL (/ bl ss len aa dell)
  (setvar "cmdecho" 0)
  (setq bl (bget "Name of block to kill or select: " 2))
  (if (and bl (/= bl ""))
      (progn
           (if (= (substr bl 1 1) "*")                ; escape * so that
               (setq bl (strcat "`" bl)))             ; can find hatches
           (setq ss (ssget "X" (list (cons 2 bl))))
           (setq bl (strcat (strcase (substr bl 1 1))
                    (strcase (substr bl 2) t)))
           (if ss
              (progn
                   (setq len (sslength ss))
                   (command "erase" ss "")
                   (if (= (substr bl 1 1) "`")        ; remove hatch * escape
                       (setq bl (substr bl 2)))       ; char ` if present
                   (prompt (strcat "\n" (itoa len) " " bl
                                   " insert" (if (/= len 1) "s" "")
                                   " erased.")))
              (prompt (strcat "\nNo " bl " inserts found.")))))
 (princ))